import javax.media.j3d.*;
import javax.vecmath.*;
import java.util.*;
import java.awt.event.*;
/**
 * This class uses an alpha generator to change the weights
 * of a Morph node.  It morphs a shape between two key shapes
 * repeatedly once a key has been pressed. Subsequent key presses
 * toggle the running state of the animation.
 * @author I.J.Palmer
 * @version 1.0
 * @see SimpleMorph2
 */
public class SimpleMorphBehaviour extends Behavior {
    /** Used to drive the animation */
    protected Alpha theAlpha;
    /** The weights of this are changed by the alpha values */
    protected Morph theMorph;
    /** Used to define the Morph weights */
    protected double theWeights[] = new double[2];
    /** Defines whether the animation is running or not */
    protected boolean running = false;
    /** The triggers for the animation to start */
    protected WakeupCriterion[] wakeConditions;
    /** The combined triggers */
    protected WakeupOr oredConditions;

    /** Set up the criteria to trigger after zero time or when a key is pressed */
    public void initialize() {
        wakeConditions = new WakeupCriterion[2];
        wakeConditions[0] = new WakeupOnAWTEvent(KeyEvent.KEY_PRESSED);
        wakeConditions[1] = new WakeupOnElapsedFrames(0);
        oredConditions = new WakeupOr(wakeConditions);
        wakeupOn (wakeConditions[0]);
    }

    /** If the behaviour is not running and and a key has been pressed,
      * start the animation and vice-versa.  Otherwise calculate a new
      * set of weights.
      */
    public void processStimulus(Enumeration criteria) {
        WakeupCriterion theCriteria;
        theCriteria = (WakeupCriterion) criteria.nextElement();
        //If a key has been pressed, toggle the running state
        if (theCriteria instanceof WakeupOnAWTEvent) {
            running = !running;
        }
        if (running) { 
            //Get the alpha value
            double alphaValue = theAlpha.value();
            //Set the two weights according to this value
		theWeights[0] = 1.0 - alphaValue;
		theWeights[1] = alphaValue;
		//Use the weights in the Morph
		theMorph.setWeights(theWeights);
        }
        //Set the trigger conditions again
        wakeupOn(oredConditions);
    }

    /**
     * Set up the data for the behaviour.
     * @param a Alpha that is used to drive the animation
     * @param m Morph that is affected by this behaviour
     */
    public SimpleMorphBehaviour(Alpha a, Morph m) {
	theAlpha = a;
	theMorph = m;
    }
}


